use crate::commands::app_cmds::AppState;
use crate::terminal::pty::PtySession;
use tauri::{State, Window};
use std::sync::{Arc};


#[tauri::command]
pub async fn spawn_local_pty(
    state: State<'_, AppState>,
    window: Window,
    session_id: String,
    rows: u16,
    cols: u16
) -> Result<(), String> {
    let pty = PtySession::spawn(session_id.clone(), window, rows, cols)
        .map_err(|e| e.to_string())?;
    
    let mut map = state.local_ptys.write().await;
    map.insert(session_id, Arc::new(pty));
    
    Ok(())
}

#[tauri::command]
pub async fn send_local_pty_data(
    state: State<'_, AppState>,
    session_id: String,
    data: String
) -> Result<(), String> {
    let map = state.local_ptys.read().await;
    if let Some(pty) = map.get(&session_id) {
        pty.write(data.as_bytes()).map_err(|e| e.to_string())?;
    }
    Ok(())
}

#[tauri::command]
pub async fn resize_local_pty(
    state: State<'_, AppState>,
    session_id: String,
    rows: u16,
    cols: u16
) -> Result<(), String> {
    let map = state.local_ptys.read().await;
    if let Some(pty) = map.get(&session_id) {
        pty.resize(rows, cols).map_err(|e| e.to_string())?;
    }
    Ok(())
}