// FILE: src/connection/ssh_client.rs
// ----------------------------------
use russh::{client, ChannelId};
use ssh_key::PublicKey;
use async_trait::async_trait;

#[derive(Clone)]
pub struct ClientHandler;

impl ClientHandler {
    pub fn new() -> Self {
        Self {}
    }
}

#[async_trait]
impl client::Handler for ClientHandler {
    type Error = russh::Error;

    async fn check_server_key(
        &mut self,
        _server_public_key: &PublicKey,
    ) -> Result<bool, Self::Error> {
        // In a production app, you should verify known_hosts here.
        // For now, we blindly accept keys (like the "-o StrictHostKeyChecking=no" flag).
        Ok(true)
    }

    async fn channel_open_confirmation(
        &mut self,
        _id: ChannelId,
        _max_packet_size: u32,
        _window_size: u32,
        _session: &mut client::Session,
    ) -> Result<(), Self::Error> {
        Ok(())
    }

    async fn data(
        &mut self,
        _channel: ChannelId,
        _data: &[u8],
        _session: &mut client::Session,
    ) -> Result<(), Self::Error> {
        Ok(())
    }
}