use std::path::PathBuf;

pub const INVENTORY_FILENAME: &str = "inventory.dat";
pub const KEY_FILENAME: &str = "omniterminal.key"; 

// Safety Limits
pub const MAX_EDIT_SIZE_BYTES: u64 = 2 * 1024 * 1024; // 2MB Limit for Full Edit
pub const PREVIEW_SIZE_BYTES: u64 = 256 * 1024;       // 256KB Preview for large files

fn get_exe_relative_path(filename: &str) -> PathBuf {
    let mut path = std::env::current_exe().unwrap_or_else(|_| PathBuf::from("."));
    path.pop(); 
    path.push(filename);
    path
}

pub fn get_config_path() -> PathBuf {
    get_exe_relative_path(INVENTORY_FILENAME)
}

pub fn get_key_path() -> PathBuf {
    get_exe_relative_path(KEY_FILENAME)
}