use windows::core::{implement, HRESULT}; // Removed Result
use windows::Win32::Foundation::{BOOL, DRAGDROP_S_CANCEL, DRAGDROP_S_DROP, DRAGDROP_S_USEDEFAULTCURSORS, S_OK};
use windows::Win32::System::Ole::{IDropSource, IDropSource_Impl, DROPEFFECT};
use windows::Win32::System::SystemServices::MODIFIERKEYS_FLAGS;

#[implement(IDropSource)]
pub struct DropSource;

impl DropSource {
    pub fn new() -> Self {
        Self {}
    }
}

impl IDropSource_Impl for DropSource {
    fn QueryContinueDrag(&self, escape_pressed: BOOL, key_state: MODIFIERKEYS_FLAGS) -> HRESULT {
        if escape_pressed.as_bool() {
            return DRAGDROP_S_CANCEL;
        }

        // Check Left Mouse Button (MK_LBUTTON = 0x0001)
        if (key_state.0 & 1) == 0 {
            return DRAGDROP_S_DROP;
        }

        S_OK
    }

    fn GiveFeedback(&self, _effect: DROPEFFECT) -> HRESULT {
        DRAGDROP_S_USEDEFAULTCURSORS
    }
}