use serde::{Deserialize, Serialize};
use std::collections::HashMap;
use std::time::Instant;

#[derive(Debug, Clone, Serialize, Deserialize, Default)]
pub struct HostStats {
    pub cpu_usage: f32,
    pub highest_cpu_core_usage: f32,
    
    pub ram_used: u64,
    pub ram_total: u64,
    
    pub root_disk_usage: f32,
    pub disk_details: Vec<(String, f32)>,
    
    pub net_rx_mbps: f32,
    pub net_tx_mbps: f32,

    pub debug_raw: Option<String>,
}

pub struct MonitorState {
    pub last_net_rx: u64,
    pub last_net_tx: u64,
    pub last_cpu_total: u64,
    pub last_cpu_work: u64,
    pub core_states: HashMap<String, (u64, u64)>,
    pub last_check_time: Instant,
}

impl Default for MonitorState {
    fn default() -> Self {
        Self {
            last_net_rx: 0,
            last_net_tx: 0,
            last_cpu_total: 0,
            last_cpu_work: 0,
            core_states: HashMap::new(),
            last_check_time: Instant::now(),
        }
    }
}