use serde::{Deserialize, Serialize};

#[derive(Debug, Clone, Serialize, Deserialize)]
pub struct DeviceFingerprint {
    pub port_name: String,
    pub friendly_name: String,
    pub hardware_id: String,
    pub instance_id: String,
}

#[derive(Debug, Clone)]
pub struct BytecodeConfig {
    pub tx_prefix: Vec<u8>,
    pub tx_suffix: Vec<u8>,
    pub force_crlf: bool,
}

impl Default for BytecodeConfig {
    fn default() -> Self {
        Self {
            tx_prefix: Vec::new(),
            tx_suffix: Vec::new(),
            force_crlf: false,
        }
    }
}

// NEW: Control Enum for Supervisor
#[derive(Debug)]
pub enum SerialCommand {
    WriteData(String),
    SetDtr(bool),
    SetRts(bool),
    // Future: UpdateConfig(BytecodeConfig)
}