// FILE: ui/js/conn/ui.js
// ----------------------
// Updated init to include Checkpoint Button in Shelf

window.Connections = {
    filterText: "",

    init: async () => {
        if (window.ConnStore) await window.ConnStore.load();
        if (typeof ConnWizard !== 'undefined') ConnWizard.init();

        const shelfAddBtn = document.getElementById('shelf-add-btn');
        if (shelfAddBtn) {
            shelfAddBtn.onclick = (e) => {
                e.preventDefault(); e.stopPropagation();
                if(typeof ConnWizard !== 'undefined') {
                    ConnWizard.show(window.Connections.handleConnect, "Connect");
                }
            };
        }

        const searchInput = document.getElementById('shelf-filter');
        if (searchInput) {
            searchInput.addEventListener('input', (e) => {
                window.Connections.filterText = e.target.value.toLowerCase();
                if(typeof ConnRender !== 'undefined') ConnRender.render();
            });
        }

        // TOOLBAR BUTTONS
        const toolsContainer = document.querySelector('.shelf-tools');
        if (toolsContainer) {
            toolsContainer.innerHTML = ''; 
            
            // Helper to create tool buttons
            const createBtn = (label, title, onClick) => {
                const btn = document.createElement('button');
                btn.className = 'icon-btn';
                btn.style.fontSize = "11px";
                btn.style.border = "1px solid #444";
                btn.style.padding = "2px 8px";
                btn.style.borderRadius = "3px";
                btn.style.backgroundColor = "#333";
                btn.style.marginRight = "8px";
                btn.style.cursor = "pointer";
                btn.innerHTML = label; 
                btn.title = title;
                btn.onclick = (e) => {
                    e.preventDefault(); e.stopPropagation();
                    onClick();
                };
                return btn;
            };

            // 1. Sync Button
            toolsContainer.appendChild(createBtn(
                "🔄 Sync", 
                "Open Folder Sync Wizard", 
                () => { if (typeof SyncWizard !== 'undefined') SyncWizard.open(); }
            ));

            // 2. Checkpoint Button (NEW)
            toolsContainer.appendChild(createBtn(
                "🛡️ Checkpoint", 
                "Auto-Backup Watcher", 
                () => { if (typeof CheckpointWizard !== 'undefined') CheckpointWizard.open(); }
            ));
        }

        if(typeof ConnRender !== 'undefined') ConnRender.render();
    },

    // ... (rest of the file remains unchanged) ...
    handleConnect: (data) => {
        const { friendlyName, host, user, pass, port } = data;
        const payload = { host, user, pass, port };
        const label = friendlyName || `${user}@${host}`;

        document.querySelector('[data-target="view-ssh"]').click();
        if (typeof SshSession !== 'undefined') {
            SshSession.create(label, "quick_connect", payload);
        }
        if(typeof ConnWizard !== 'undefined') ConnWizard.hide();
    },

    connectSaved: (item) => {
        if (item.type === 'local') {
            window.Connections.focusSftp(item.id, false);
            return;
        }
        document.querySelector('[data-target="view-ssh"]').click();
        if (typeof SshSession !== 'undefined') {
            SshSession.create(item.name, item.savedId, null);
        }
    },

    editSaved: (item) => {
        if(item.type === 'local') return;
        if(typeof ConnWizard === 'undefined') return;
        ConnWizard.show(async (data) => {
            try {
                await invoke('delete_ssh_host', { id: item.savedId });
                await invoke('save_ssh_host', { 
                    name: data.friendlyName, 
                    host: data.host, 
                    user: data.user, 
                    pass: data.pass || "", 
                    port: data.port,
                    color: data.color
                });
                if(window.ConnStore) await window.ConnStore.load();
                if(typeof ConnRender !== 'undefined') ConnRender.render();
                ConnWizard.hide();
            } catch(e) { alert(e); }
        }, "Update");

        if(item.hostData) {
            document.getElementById('wiz-name').value = item.name;
            document.getElementById('wiz-host').value = item.hostData.hostname;
            document.getElementById('wiz-user').value = item.hostData.username;
            document.getElementById('wiz-port').value = item.hostData.port;
            const colorInput = document.getElementById('wiz-color');
            if(colorInput && item.hostData.color) colorInput.value = item.hostData.color;
        }
    },

    deleteSaved: async (item) => {
        if(item.type === 'local') return;
        if (!await Modal.confirm(`Delete profile "${item.name}"?`, "Confirm Delete")) return;
        try {
            await invoke('delete_ssh_host', { id: item.savedId });
            if(window.ConnStore) await window.ConnStore.load();
            if(typeof ConnRender !== 'undefined') ConnRender.render();
        } catch(e) {
            alert("Delete failed: " + e);
        }
    },

    disconnect: async (id) => {
        const item = window.ConnStore ? window.ConnStore.find(id) : null;
        if (!item) return;
        if (item.type === 'local') {
            if (typeof SshSession !== 'undefined') SshSession.close(id, false);
            return;
        }
        if (item.type === 'ssh' && typeof SshSession !== 'undefined') {
            await SshSession.close(id, false);
        }
    },

    focusTerminal: (id, altKey) => {
        const item = window.ConnStore ? window.ConnStore.find(id) : null;
        if (item && item.type === 'local') {
            document.querySelector('[data-target="view-ssh"]').click();
            if (typeof SshSession !== 'undefined') {
                SshSession.create("Local Terminal", "LOCAL", null);
            }
            return;
        }
        document.querySelector('[data-target="view-ssh"]').click();
        if (typeof SshSession !== 'undefined') SshSession.activate(id);
    },

    focusSftp: (id, altKey) => {
        document.querySelector('[data-target="view-sftp"]').click();
        const item = window.ConnStore ? window.ConnStore.find(id) : null;
        if (!item) return;

        let sftpTargetId = item.hostId;
        if (sftpTargetId === "quick_connect") sftpTargetId = item.id; 
        
        if (typeof SftpTabManager !== 'undefined') {
            const existingTab = Object.values(SftpTabManager.tabs).find(t => t.hostId === sftpTargetId);
            if (existingTab && !altKey) {
                SftpTabManager.activate(existingTab.id);
            } else {
                SftpTabManager.create(item.name, sftpTargetId, ".");
            }
        }
        if(typeof ConnRender !== 'undefined') ConnRender.render();
    },

    add: (id, name, type, hostId, payload) => {
        if(window.ConnStore) window.ConnStore.addActive({ id, name, type, hostId, payload });
        if(typeof ConnRender !== 'undefined') ConnRender.render();
    },

    remove: (id) => {
        if(window.ConnStore) window.ConnStore.removeById(id);
        if(typeof ConnRender !== 'undefined') ConnRender.render();
    },

    updateStatus: (id, status) => {
        if(window.ConnStore) window.ConnStore.updateStatus(id, status);
        if(typeof ConnRender !== 'undefined') ConnRender.render();
    },

    render: () => {
        if(typeof ConnRender !== 'undefined') ConnRender.render();
    }
};

const Connections = window.Connections;