// FILE: ui/js/conn/wizard.js
// --------------------------

const ConnWizard = {
    callback: null,

    init: () => {
        const cancelBtn = document.getElementById('wiz-btn-cancel');
        if (cancelBtn) cancelBtn.onclick = ConnWizard.hide;
        
        const connectBtn = document.getElementById('wiz-btn-connect');
        if (connectBtn) {
            connectBtn.onclick = () => {
                const data = ConnWizard.validate();
                if (data && ConnWizard.callback) {
                    ConnWizard.callback(data);
                }
            };
        }

        const saveBtn = document.getElementById('wiz-btn-save-connect');
        if (saveBtn) {
            saveBtn.onclick = ConnWizard.onSaveAndConnect;
        }
    },

    show: (onConfirm, buttonText = "Connect") => {
        const modal = document.getElementById('connection-wizard-modal');
        if (!modal) return;
        
        modal.style.display = 'flex';
        
        // Reset Fields
        const fields = ['wiz-name', 'wiz-host', 'wiz-user', 'wiz-pass'];
        fields.forEach(id => {
            const el = document.getElementById(id);
            if(el) el.value = "";
        });
        
        // Default Port
        const portEl = document.getElementById('wiz-port');
        if(portEl) portEl.value = "22";
        
        const colorInput = document.getElementById('wiz-color');
        if(colorInput) colorInput.value = "#cccccc"; 

        const hostInput = document.getElementById('wiz-host');
        if(hostInput) hostInput.focus();

        const btn = document.getElementById('wiz-btn-connect');
        if(btn) btn.innerText = buttonText;
        
        ConnWizard.callback = onConfirm;
    },

    hide: () => {
        const modal = document.getElementById('connection-wizard-modal');
        if (modal) modal.style.display = 'none';
        ConnWizard.callback = null;
    },

    validate: () => {
        const nameVal = document.getElementById('wiz-name').value.trim();
        const host = document.getElementById('wiz-host').value.trim();
        const user = document.getElementById('wiz-user').value.trim();
        const pass = document.getElementById('wiz-pass').value;
        
        let port = 22;
        try {
            const pVal = document.getElementById('wiz-port').value;
            port = parseInt(pVal);
            if (isNaN(port)) port = 22;
        } catch(e) {}

        const colorEl = document.getElementById('wiz-color');
        const color = colorEl ? colorEl.value : "#cccccc";

        if (!host) { alert("Host is required"); document.getElementById('wiz-host').focus(); return null; }
        if (!user) { alert("User is required"); document.getElementById('wiz-user').focus(); return null; }

        const friendlyName = nameVal || `${user}@${host}`;

        return { friendlyName, host, user, pass, port, color };
    },

    onSaveAndConnect: async () => {
        const data = ConnWizard.validate();
        if (!data) return;

        console.log("[Wizard] Attempting to save host:", data.host);

        try {
            // 1. Save to Backend
            // Ensure port is a number for Rust
            await invoke('save_ssh_host', { 
                name: data.friendlyName, 
                host: data.host, 
                user: data.user, 
                pass: data.pass || "", 
                port: Number(data.port), 
                color: data.color
            });
            
            console.log("[Wizard] Backend save success. Reloading store...");

            // 2. Force Store Reload
            if (typeof ConnStore !== 'undefined') {
                await ConnStore.load();
            }

            // 3. Force UI Render
            if (typeof Connections !== 'undefined' && typeof Connections.render === 'function') {
                Connections.render();
            }
            
            // 4. Connect
            let savedItem = null;
            if (typeof ConnStore !== 'undefined') {
                savedItem = ConnStore.getSavedByHostUser(data.host, data.user);
            }
            
            if (savedItem && typeof Connections !== 'undefined') {
                console.log("[Wizard] Connecting via Saved Profile:", savedItem.id);
                Connections.connectSaved(savedItem);
            } else if (typeof Connections !== 'undefined') {
                console.log("[Wizard] Profile not found in store after save? Connecting ad-hoc.");
                Connections.handleConnect(data); 
            }
            
            ConnWizard.hide();

        } catch(e) {
            console.error("[Wizard] Save Error:", e);
            alert("Failed to save connection:\n" + e);
        }
    }
};