// ui/js/sftp/clipboard.js
// Batch 10: Updated for Multi-Select Support

const SftpClipboard = {
    sourcePaths: [], // Changed to Array
    operation: null, 
    sourceHostId: null,

    copy: (items) => {
        // Items is an array of FileData or a single path string (compatibility)
        if (Array.isArray(items)) {
            SftpClipboard.sourcePaths = items.map(i => i.path);
        } else {
            SftpClipboard.sourcePaths = [items];
        }
        
        SftpClipboard.operation = "copy";
        SftpClipboard.sourceHostId = SftpUtils.getActiveSshId();
        console.log(`[Clipboard] Copied ${SftpClipboard.sourcePaths.length} items`);
    },

    cut: (items) => {
        if (Array.isArray(items)) {
            SftpClipboard.sourcePaths = items.map(i => i.path);
        } else {
            SftpClipboard.sourcePaths = [items];
        }

        SftpClipboard.operation = "cut";
        SftpClipboard.sourceHostId = SftpUtils.getActiveSshId();
        if (window.refreshSftp) window.refreshSftp(); 
        console.log(`[Clipboard] Cut ${SftpClipboard.sourcePaths.length} items`);
    },

    paste: async (destFolder) => {
        if (SftpClipboard.sourcePaths.length === 0 || !SftpClipboard.operation) {
            return;
        }

        const targetHostId = SftpUtils.getActiveSshId();
        if(!targetHostId) return;

        // Note: Project 4 will handle cross-server paste. 
        // For now, we assume same-server.
        if (SftpClipboard.sourceHostId !== targetHostId) {
             alert("Cross-server copy not yet implemented. Use System Clipboard (Alt+Click).");
             return;
        }

        SftpUI.showLoading();

        try {
            for (const srcPath of SftpClipboard.sourcePaths) {
                const filename = srcPath.split('/').pop();
                const destPath = SftpUtils.joinPath(destFolder, filename);

                if (srcPath === destPath) continue;

                if (SftpClipboard.operation === "copy") {
                    await invoke('sftp_copy', {
                        hostId: targetHostId,
                        src: srcPath,
                        dst: destPath
                    });
                } else if (SftpClipboard.operation === "cut") {
                    await invoke('sftp_rename', {
                        hostId: targetHostId,
                        src: srcPath,
                        dst: destPath
                    });
                }
            }

            if (SftpClipboard.operation === "cut") SftpClipboard.clear();
            if (window.refreshSftp) window.refreshSftp();

        } catch (e) {
            alert(`Paste failed: ${e}`);
            console.error("Paste Error", e);
            if (window.refreshSftp) window.refreshSftp(); 
        }
    },

    clear: () => {
        SftpClipboard.sourcePaths = [];
        SftpClipboard.operation = null;
        SftpClipboard.sourceHostId = null;
    },

    isCut: (path) => {
        return SftpClipboard.operation === "cut" && SftpClipboard.sourcePaths.includes(path);
    }
};