// ui/js/sftp/history.js

const SftpHistory = {
    stack: [],
    ptr: -1,
    lastHostId: null,

    // Called when user clicks a folder or types a path
    push: (path, hostId) => {
        // If we switched hosts, wipe history
        if (SftpHistory.lastHostId !== hostId) {
            SftpHistory.clear();
            SftpHistory.lastHostId = hostId;
        }

        // If we are refreshing the same folder, don't grow stack
        if (SftpHistory.ptr >= 0 && SftpHistory.stack[SftpHistory.ptr] === path) {
            return;
        }

        // If we were back in history and navigated somewhere new, 
        // truncate the "future" history
        if (SftpHistory.ptr < SftpHistory.stack.length - 1) {
            SftpHistory.stack = SftpHistory.stack.slice(0, SftpHistory.ptr + 1);
        }

        SftpHistory.stack.push(path);
        SftpHistory.ptr++;
    },

    // Returns path to go back to, or null
    goBack: () => {
        if (SftpHistory.ptr > 0) {
            SftpHistory.ptr--;
            return SftpHistory.stack[SftpHistory.ptr];
        }
        return null;
    },

    // Returns path to go forward to, or null
    goForward: () => {
        if (SftpHistory.ptr < SftpHistory.stack.length - 1) {
            SftpHistory.ptr++;
            return SftpHistory.stack[SftpHistory.ptr];
        }
        return null;
    },

    clear: () => {
        SftpHistory.stack = [];
        SftpHistory.ptr = -1;
    }
};