// ui/js/sftp/menus.js
// Batch 10: Context Menu Multi-Select Update

const SftpMenus = {
    hide: () => {
        const menu = document.getElementById('sftp-ctx-menu');
        if(menu) menu.style.display = 'none';
    },

    show: (x, y, selectedItems, callbacks) => {
        const menu = document.getElementById('sftp-ctx-menu');
        if (!menu) return;

        // selectedItems is now always an array
        const count = selectedItems.length;
        const isSingle = count === 1;

        menu.style.left = x + 'px';
        menu.style.top = y + 'px';
        menu.style.display = 'block';

        const newMenu = menu.cloneNode(true);
        
        // Disable "Rename" if multiple items selected
        const renameItem = newMenu.querySelector('[data-action="rename"]');
        if (renameItem && !isSingle) {
            renameItem.style.opacity = "0.5";
            renameItem.style.pointerEvents = "none";
            renameItem.innerText = "Rename (Single only)";
        }

        // Update Labels for clarity
        const delItem = newMenu.querySelector('[data-action="delete"]');
        if (delItem) delItem.innerText = isSingle ? "Delete" : `Delete ${count} items`;

        const copyItem = newMenu.querySelector('[data-action="copy"]');
        if (copyItem) copyItem.innerText = isSingle ? "Copy" : `Copy ${count} items`;

        // Ensure "Copy to System" option exists
        if (!newMenu.querySelector('[data-action="sys_copy"]')) {
            const div = document.createElement('div');
            div.className = "ctx-item";
            div.dataset.action = "sys_copy";
            div.innerText = "Copy to System (Ctrl+C)";
            div.style.borderTop = "1px solid #444";
            newMenu.appendChild(div);
        }

        menu.parentNode.replaceChild(newMenu, menu);
        
        newMenu.querySelectorAll('.ctx-item').forEach(item => {
            item.onclick = async () => {
                newMenu.style.display = 'none';
                const action = item.dataset.action;
                
                if (action === 'rename' && isSingle) callbacks.onRename(selectedItems[0]);
                else if (action === 'delete') callbacks.onDelete(selectedItems);
                else if (action === 'copy') callbacks.onCopy(selectedItems);
                else if (action === 'cut') callbacks.onCut(selectedItems);
                else if (action === 'sys_copy') {
                    // System copy only supports single file currently
                    if (!isSingle) {
                        alert("System clipboard only supports one file at a time.");
                        return;
                    }
                    const hostId = SftpUtils.getActiveSshId();
                    try {
                        await invoke('sftp_to_clipboard', { hostId, path: selectedItems[0].path });
                    } catch(e) { alert("Copy Failed: " + e); }
                }
            };
        });
    }
};