// FILE: ui/js/sftp/ops.js
// -----------------------
// BATCH 6 FIX: Auto-open file on creation

window.SftpOps = {
    
    // ... diagnoseError remains the same ...
    diagnoseError: async (action, path, originalError) => {
        // (Existing logic omitted for brevity, it is unchanged)
        const errStr = String(originalError).toLowerCase();
        if (!errStr.includes("permission") && !errStr.includes("access") && !errStr.includes("failure")) {
            await Modal.alert(`${action} failed: ${originalError}`, "Error");
            return;
        }
        // ...
        await Modal.alert(`${action} failed: ${originalError}`, "Error");
    },

    createEntry: (isDir) => {
        SftpUI.showPhantomInput(isDir, async (name) => {
            const activeTab = typeof SftpTabManager !== 'undefined' ? SftpTabManager.getActive() : null;
            if (!activeTab) return;

            const hostId = activeTab.hostId;
            const currentPath = activeTab.path;

            let fullPath = name;
            if (currentPath && currentPath !== "." && currentPath !== "") {
                 fullPath = SftpUtils.joinPath(currentPath, name);
            }
            
            console.log(`[SFTP] Creating ${isDir ? 'folder' : 'file'}: ${fullPath} on ${hostId}`);

            try {
                await invoke('sftp_create_entry', { hostId: hostId, path: fullPath, isDir });
                if (window.refreshSftp) await window.refreshSftp();
                
                // NEW: Open file immediately if it's a file
                if (!isDir) {
                    setTimeout(() => SftpEditor.load(fullPath, 0), 200);
                }

            } catch(e) { 
                await window.SftpOps.diagnoseError("Creation", currentPath || ".", e);
            }
        });
    },

    renameEntry: async (oldPath, newName) => {
        // ... (Existing implementation) ...
        const activeTab = typeof SftpTabManager !== 'undefined' ? SftpTabManager.getActive() : null;
        if (!activeTab) return;
        const hostId = activeTab.hostId;
        
        const parentDir = SftpUtils.getParentPath(oldPath);
        let newPath = newName;
        if (parentDir && parentDir !== "/") {
            newPath = SftpUtils.joinPath(parentDir, newName);
        } else if (parentDir === "/") {
            newPath = "/" + newName;
        }

        try {
            await invoke('sftp_rename', { hostId, src: oldPath, dst: newPath });
            if (window.refreshSftp) window.refreshSftp();
        } catch(e) {
            await window.SftpOps.diagnoseError("Rename", oldPath, e);
        }
    },

    deleteEntry: async (fullPath, isDir, forcedRecursive) => {
        // ... (Existing implementation) ...
        const activeTab = typeof SftpTabManager !== 'undefined' ? SftpTabManager.getActive() : null;
        if (!activeTab) return;
        const hostId = activeTab.hostId;

        try {
            await invoke('sftp_delete', { hostId, path: fullPath, recursive: forcedRecursive || false });
            if (window.refreshSftp) window.refreshSftp();
        } catch(e) { 
            if (isDir && !forcedRecursive) {
                const msg = `Failed to delete folder "${fullPath}".\nReason: ${e}\n\nIt may not be empty. Delete recursively?`;
                if (await Modal.confirm(msg, "Recursive Delete Required")) {
                    window.SftpOps.deleteEntry(fullPath, true, true);
                }
            } else {
                await window.SftpOps.diagnoseError("Delete", fullPath, e);
            }
        }
    },

    moveEntry: async (srcPath, dstPath) => {
        // ... (Existing implementation) ...
        const activeTab = typeof SftpTabManager !== 'undefined' ? SftpTabManager.getActive() : null;
        if (!activeTab) return;
        const hostId = activeTab.hostId;

        if (srcPath === dstPath) return;

        try {
            await invoke('sftp_rename', { hostId, src: srcPath, dst: dstPath });
            if (window.refreshSftp) window.refreshSftp();
        } catch(e) {
            await window.SftpOps.diagnoseError("Move", srcPath, e);
            if (window.refreshSftp) window.refreshSftp();
        }
    }
};