// FILE: ui/js/sftp/tabs.js
// ------------------------

const SftpTabManager = {
    activeTabId: null,
    tabs: {}, 

    init: () => {
        SftpTabManager.create("Local", "LOCAL", ".");
    },

    create: (name, hostId, initialPath = ".") => {
        const tabId = "sftp_tab_" + Math.random().toString(36).substr(2, 9);
        const sessContainer = document.getElementById('sftp-sessions-container');

        const panel = document.createElement('div');
        panel.className = "sftp-session-panel";
        panel.id = `panel_${tabId}`;
        panel.style.display = 'none';

        panel.innerHTML = `
            <div class="sftp-path-bar">
                <input type="text" class="sftp-path-input" value="${initialPath}" />
                <button class="sftp-refresh-btn icon-btn" title="Refresh">↻</button>
                <button class="sftp-go-btn icon-btn" style="font-size: 12px; border: 1px solid #3e3e42; padding: 2px 8px;">Go</button>
            </div>
            <ul class="inventory-list sftp-list" tabindex="0"></ul>
        `;

        sessContainer.appendChild(panel);

        const t = {
            id: tabId, name, hostId, path: initialPath, panel, history: []
        };
        SftpTabManager.tabs[tabId] = t;

        const input = panel.querySelector('.sftp-path-input');
        const goBtn = panel.querySelector('.sftp-go-btn');
        const refBtn = panel.querySelector('.sftp-refresh-btn');

        goBtn.onclick = () => { if(typeof refreshSftp === 'function') refreshSftp(input.value.trim()); };
        refBtn.onclick = () => { if(typeof refreshSftp === 'function') refreshSftp(undefined, false); };
        
        input.addEventListener('keydown', (e) => {
            if (e.key === 'Enter') goBtn.click();
        });

        SftpTabManager.activate(tabId);
    },

    activate: (tabId) => {
        if (!SftpTabManager.tabs[tabId]) return;

        Object.values(SftpTabManager.tabs).forEach(t => {
            t.panel.style.display = 'none';
        });

        const t = SftpTabManager.tabs[tabId];
        t.panel.style.display = 'flex';
        t.panel.style.flexDirection = 'column';
        t.panel.style.height = '100%';
        
        SftpTabManager.activeTabId = tabId;

        if (typeof refreshSftp === 'function') {
            refreshSftp(t.path, false); 
        }

        if (typeof Connections !== 'undefined' && typeof Connections.render === 'function') {
            Connections.render();
        }
    },

    close: (tabId) => {
        const t = SftpTabManager.tabs[tabId];
        if (!t) return;
        
        t.panel.remove();
        delete SftpTabManager.tabs[tabId];

        if (SftpTabManager.activeTabId === tabId) {
            const keys = Object.keys(SftpTabManager.tabs);
            if (keys.length > 0) SftpTabManager.activate(keys[keys.length-1]);
            else SftpTabManager.activeTabId = null;
        }
    },

    getActive: () => {
        if (!SftpTabManager.activeTabId) return null;
        return SftpTabManager.tabs[SftpTabManager.activeTabId];
    }
};

// Batch 10: Corrected CSS injection to fix scrolling
{
    const sftpTabStyle = document.createElement('style');
    sftpTabStyle.innerHTML = `
        #sftp-sessions-container {
            display: flex; 
            flex-direction: column; 
            overflow: hidden; 
            height: 100%;
            flex-grow: 1;
            min-height: 0; /* Crucial for scrolling children */
        }
        .sftp-session-panel { 
            flex-grow: 1; 
            display: flex; 
            flex-direction: column; 
            overflow: hidden;
            min-height: 0; /* Crucial for scrolling children */
            height: 100%;
        }
        .sftp-path-bar {
            padding: 6px; 
            border-bottom: 1px solid #3e3e42; 
            display: flex; 
            gap: 5px; 
            background: #252526;
            flex-shrink: 0;
            align-items: center;
        }
        .sftp-path-input {
            flex-grow: 1; 
            background: #3c3c3c; 
            border: 1px solid #3e3e42; 
            color: white;
            padding: 2px 5px; 
            font-size: 11px; 
            outline: none;
        }
        .sftp-list { 
            flex-grow: 1; 
            overflow-y: auto; /* Correct scroll behavior */
            outline: none; 
            min-height: 0; 
            height: auto;
        }
    `;
    document.head.appendChild(sftpTabStyle);
}