// FILE: ui/js/sftp/tabs.js
// ------------------------

const SftpTabs = {
    activeTabId: null,
    tabs: {}, 

    init: () => {
        // Init Local Tab
        SftpTabs.create("Local", "LOCAL", ".");
    },

    create: (name, hostId, initialPath = ".") => {
        const tabId = "sftp_tab_" + Math.random().toString(36).substr(2, 9);
        const sessContainer = document.getElementById('sftp-sessions-container');

        // Create Panel ONLY (No Tab Button)
        const panel = document.createElement('div');
        panel.className = "sftp-session-panel";
        panel.id = `panel_${tabId}`;
        panel.style.display = 'none';

        panel.innerHTML = `
            <div class="sftp-path-bar">
                <input type="text" class="sftp-path-input" value="${initialPath}" />
                <button class="sftp-go-btn icon-btn" style="font-size: 12px; border: 1px solid #3e3e42; padding: 2px 8px;">Go</button>
            </div>
            <ul class="inventory-list sftp-list" tabindex="0"></ul>
        `;

        sessContainer.appendChild(panel);

        SftpTabs.tabs[tabId] = {
            id: tabId, name, hostId, path: initialPath, panel, history: []
        };

        SftpTabs.activate(tabId);
    },

    activate: (tabId) => {
        if (!SftpTabs.tabs[tabId]) return;

        Object.values(SftpTabs.tabs).forEach(t => {
            t.panel.style.display = 'none';
        });

        const t = SftpTabs.tabs[tabId];
        t.panel.style.display = 'flex';
        t.panel.style.flexDirection = 'column';
        t.panel.style.height = '100%';
        
        SftpTabs.activeTabId = tabId;

        if (typeof refreshSftp === 'function') {
            refreshSftp(t.path, false); 
        }
    },

    close: (tabId) => {
        const t = SftpTabs.tabs[tabId];
        if (!t) return;
        
        t.panel.remove();
        delete SftpTabs.tabs[tabId];

        if (SftpTabs.activeTabId === tabId) {
            const keys = Object.keys(SftpTabs.tabs);
            if (keys.length > 0) SftpTabs.activate(keys[keys.length-1]);
            else SftpTabs.activeTabId = null;
        }
    },

    getActive: () => {
        if (!SftpTabs.activeTabId) return null;
        return SftpTabs.tabs[SftpTabs.activeTabId];
    }
};

// CSS Injection
const style = document.createElement('style');
style.innerHTML = `
    .sftp-session-panel { flex-grow: 1; display: flex; flex-direction: column; overflow: hidden; }
    .sftp-path-bar {
        padding: 6px; border-bottom: 1px solid #3e3e42; display: flex; gap: 5px; background: #252526;
    }
    .sftp-path-input {
        flex-grow: 1; background: #3c3c3c; border: 1px solid #3e3e42; color: white;
        padding: 2px 5px; font-size: 11px; outline: none;
    }
    .sftp-list { flex-grow: 1; overflow-y: auto; outline: none; }
`;
document.head.appendChild(style);