// FILE: ui/js/tabs.js
// -------------------

function initTabs() {
    const tabs = document.querySelectorAll('.tab');
    
    tabs.forEach(tab => {
        tab.addEventListener('click', () => {
            const targetId = tab.getAttribute('data-target');
            if(!targetId) return;

            document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
            document.querySelectorAll('.view-panel').forEach(v => v.classList.remove('active'));
            
            tab.classList.add('active');
            document.getElementById(targetId).classList.add('active');

            // 1. SERIAL
            if (targetId === 'view-serial' && AppState.serial.fit) {
                setTimeout(() => AppState.serial.fit.fit(), 50);
            }
            
            // 2. SSH
            if (targetId === 'view-ssh') {
                const activeSid = AppState.ssh.activeSessionId;
                if (activeSid && AppState.ssh.sessions[activeSid]) {
                    const s = AppState.ssh.sessions[activeSid];
                    if (s.fit) setTimeout(() => s.fit.fit(), 50);
                }
            }
            
            // 3. SFTP (Batch 6 Logic)
            if (targetId === 'view-sftp') {
                handleSftpTabActivation();
            }

            // Force Shelf Re-render to update highlighting
            if (typeof Connections !== 'undefined' && Connections.render) {
                Connections.render();
            }
        });
    });
}

function handleSftpTabActivation() {
    // If we have an active SFTP tab, just refresh it
    if (typeof SftpTabManager !== 'undefined' && SftpTabManager.getActive()) {
        if (typeof refreshSftp === 'function') {
            refreshSftp(undefined, false);
        }
        return;
    }

    // If NO active SFTP tab, check if we have an active SSH session to piggyback on
    const activeSshId = AppState.ssh.activeSessionId;
    if (activeSshId && AppState.ssh.sessions[activeSshId]) {
        const sshSession = AppState.ssh.sessions[activeSshId];
        
        console.log(`[Tabs] Auto-connecting SFTP to active SSH: ${sshSession.name}`);
        
        if (typeof SftpTabManager !== 'undefined') {
            // Check if a tab for this host already exists but isn't active
            // Note: SSH Session ID ("sess_...") is used as the hostId for ad-hoc connections
            // For saved connections, sshSession.hostId is the UUID.
            
            let targetHostId = sshSession.hostId;
            // If it's a quick connect, we MUST use the session ID to piggyback
            if (targetHostId === "quick_connect") {
                targetHostId = activeSshId; 
            }

            // Look for existing tab
            const existingTab = Object.values(SftpTabManager.tabs).find(t => t.hostId === targetHostId);
            
            if (existingTab) {
                SftpTabManager.activate(existingTab.id);
            } else {
                // Create new tab
                SftpTabManager.create(sshSession.name, targetHostId, ".");
            }
        }
    }
}