// FILE: ui/js/templates/loader.js
// -------------------------------
// BATCH 31 FIX: Added binding for 'btn-about-close'

window.Templates = window.Templates || {};

window.Templates.inject = () => {
    if (document.getElementById('about-modal')) return;

    console.log("[Loader] Injecting templates...");

    const modals = window.Templates.Modals || {};
    const menus = window.Templates.Menus || {};

    // 1. Explicit ID Mapping
    const modalMap = {
        'aboutModal': 'about-modal',
        'connectionWizard': 'connection-wizard-modal',
        'syncWizard': 'sync-wizard-modal',
        'checkpointWizard': 'checkpoint-wizard-modal',
        'genericModal': 'modal-overlay',
        'progressModal': 'progress-modal'
    };

    // 2. Inject Modals
    Object.keys(modals).forEach(key => {
        const domId = modalMap[key];
        if (domId) {
            const className = (key === 'progressModal') ? 'progress-modal' : 'modal-overlay';
            window.Templates.injectModal(domId, modals[key], className);
        }
    });
    
    // 3. Inject Menus
    Object.keys(menus).forEach(key => {
        const id = key.replace(/([a-z0-9])([A-Z])/g, '$1-$2').toLowerCase().replace('context-menu', '-ctx-menu');
        window.Templates.injectMenu(id, menus[key]);
    });

    // 4. Init Keyboard
    if (window.KeyboardRenderer) setTimeout(window.KeyboardRenderer.render, 100);

    // 5. Global Modal Close Logic (Background Click)
    window.addEventListener('click', (e) => {
        const targetId = e.target.id;
        const handlers = {
            'connection-wizard-modal': () => typeof ConnWizard !== 'undefined' && ConnWizard.hide(),
            'sync-wizard-modal': () => typeof SyncWizard !== 'undefined' && SyncWizard.hide(),
            'checkpoint-wizard-modal': () => typeof CheckpointWizard !== 'undefined' && CheckpointWizard.hide(),
            'about-modal': () => document.getElementById('about-modal').style.display = 'none'
        };
        if (handlers[targetId] && e.target.style.display !== 'none') {
            handlers[targetId]();
        }
    });

    // 6. Explicit Button Bindings (Batch 31 Fix)
    const aboutCloseBtn = document.getElementById('btn-about-close');
    if (aboutCloseBtn) {
        aboutCloseBtn.onclick = () => {
            document.getElementById('about-modal').style.display = 'none';
        };
    }
};

window.Templates.injectModal = (id, innerHTML, className="modal-overlay") => {
    if (document.getElementById(id)) return;
    const div = document.createElement('div');
    div.id = id;
    div.className = className;
    div.style.display = 'none';
    if (id.includes('wizard') || id.includes('about')) div.style.zIndex = '6000';
    div.innerHTML = innerHTML;
    document.body.appendChild(div);
};

window.Templates.injectMenu = (id, innerHTML) => {
    if (document.getElementById(id)) return;
    const div = document.createElement('div');
    div.id = id;
    div.className = "ctx-menu";
    div.style.display = 'none';
    div.innerHTML = innerHTML;
    document.body.appendChild(div);
};

// Security UI Initialization
window.Templates.initSecurityUI = () => {
    const btnChange = document.getElementById('btn-sec-change');
    if (!btnChange) return;

    window.Templates.refreshSecurityStatus = async () => {
        try {
            const isEnc = await window.invoke('get_security_status');
            const txt = document.getElementById('sec-status-text');
            const rem = document.getElementById('btn-sec-remove');
            const change = document.getElementById('btn-sec-change');
            if(txt) {
                txt.innerText = isEnc ? "Encrypted" : "Plain";
                txt.style.color = isEnc ? "#50fa7b" : "#f1fa8c";
            }
            if(rem) rem.style.display = isEnc ? "block" : "none";
            if(change) change.innerText = isEnc ? "Change Password" : "Set Master Password";
        } catch(e) {}
    };

    // Helper bind
    const bind = (id, fn) => { const el = document.getElementById(id); if(el) el.onclick = fn; };

    bind('btn-sec-change', () => {
        document.getElementById('btn-sec-change').style.display='none';
        document.getElementById('sec-form').style.display='flex';
        document.getElementById('sec-new-pass').focus();
    });
    
    bind('btn-sec-cancel', () => {
        document.getElementById('sec-form').style.display='none';
        document.getElementById('btn-sec-change').style.display='block';
    });

    bind('btn-sec-save', async () => {
        const p = document.getElementById('sec-new-pass').value;
        const p2 = document.getElementById('sec-confirm-pass').value;
        if(p !== p2) return alert("Passwords do not match");
        if(p) {
            await window.invoke('set_master_password', { newPass: p });
            alert("Password Set");
            window.Templates.refreshSecurityStatus();
            document.getElementById('btn-sec-cancel').click();
        }
    });

    bind('btn-sec-remove', async () => {
        await window.invoke('set_master_password', { newPass: null });
        alert("Password Removed");
        window.Templates.refreshSecurityStatus();
        document.getElementById('btn-sec-cancel').click();
    });
};