// FILE: ui/js/templates/modals_conn.js
// ------------------------------------
// Connection & Sync Wizards

window.Templates = window.Templates || {};
window.Templates.Modals = window.Templates.Modals || {};

window.Templates.Modals.connectionWizard = `
    <div class="modal-box" style="width: 400px;">
        <div class="modal-title">New Connection</div>
        <div class="modal-body" style="display:flex; flex-direction:column; gap:10px;">
            <div>
                <label style="font-size:11px; color:#888;">Friendly Name (Optional)</label>
                <input type="text" id="wiz-name" placeholder="e.g. Production DB" style="width:100%">
            </div>
            <div style="display:flex; gap:10px;">
                <div style="flex:3">
                    <label style="font-size:11px; color:#888;">Host</label>
                    <input type="text" id="wiz-host" placeholder="192.168.1.1" style="width:100%">
                </div>
                <div style="flex:1">
                    <label style="font-size:11px; color:#888;">Port</label>
                    <input type="text" id="wiz-port" value="22" style="width:100%">
                </div>
            </div>
            <div style="display:flex; gap:10px;">
                 <div style="flex:1">
                    <label style="font-size:11px; color:#888;">User</label>
                    <input type="text" id="wiz-user" placeholder="root" style="width:100%">
                </div>
                <div style="flex:1">
                    <label style="font-size:11px; color:#888;">Password</label>
                    <input type="password" id="wiz-pass" placeholder="Optional" style="width:100%">
                </div>
            </div>
            <div style="display:flex; gap:10px; align-items:flex-end;">
                <div style="flex:1;">
                    <label style="font-size:11px; color:#888;">Label Color</label>
                    <input type="color" id="wiz-color" value="#cccccc" style="width:100%; height:26px; border:none; background:transparent; cursor:pointer;">
                </div>
                <div style="flex:2;"></div>
            </div>
        </div>
        <div class="modal-buttons" style="display:flex; justify-content:space-between;">
            <button id="wiz-btn-connect">Connect</button>
            <div style="display:flex; gap:10px;">
                <button id="wiz-btn-save-connect" style="background-color: #555;">Connect & Save</button>
                <button id="wiz-btn-cancel" style="background-color: #3e3e42;">Cancel</button>
            </div>
        </div>
    </div>
`;

window.Templates.Modals.syncWizard = `
    <div class="modal-box" style="width: 700px; max-height: 85vh; height: auto; display:flex; flex-direction:column; background-color: #1e1e1e; border: 1px solid #3e3e42; box-shadow: 0 0 40px rgba(0,0,0,0.7);">
        
        <div class="modal-title" style="display:flex; justify-content:space-between; align-items:center; padding: 12px 20px; background-color: #252526; border-bottom: 1px solid #333; flex-shrink: 0;">
            <div style="display:flex; align-items:center; gap:10px;">
                <span style="font-size:15px; font-weight:600; color:#fff;">🔄 Sync Folders</span>
                <span style="font-size:10px; color:#aaa; background:#333; padding:2px 8px; border-radius:10px; border:1px solid #444;">Dry Run Mode</span>
            </div>
            <div style="font-size:18px; cursor:pointer; color:#888;" onclick="document.getElementById('sync-btn-cancel').click()">×</div>
        </div>

        <div style="flex-grow: 1; overflow-y: auto; display:flex; flex-direction:column; min-height: 0;">
            
            <div style="padding: 20px; background-color: #1e1e1e; flex-shrink: 0;">
                <div style="display:grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 15px;">
                    <div style="background: #252526; padding: 12px; border-radius: 4px; border: 1px solid #333;">
                        <div style="margin-bottom:8px; font-size:11px; font-weight:bold; color:#50fa7b; text-transform:uppercase;">💻 Local Source</div>
                        <input type="text" id="sync-local-path" placeholder="C:/Projects/MyApp" style="width:100%; box-sizing:border-box; padding:6px; background:#1e1e1e; border:1px solid #444; color:#fff; border-radius:3px; font-size:12px;">
                    </div>
                    <div style="background: #252526; padding: 12px; border-radius: 4px; border: 1px solid #333;">
                        <div style="margin-bottom:8px; font-size:11px; font-weight:bold; color:#007acc; text-transform:uppercase;">☁️ Remote Dest</div>
                        <select id="sync-remote-host" class="sync-host-select" style="width:100%; padding:5px; background:#1e1e1e; color:#fff; border:1px solid #444; border-radius:3px; margin-bottom:8px; font-size:12px;"></select>
                        <input type="text" id="sync-remote-path" placeholder="/var/www/html" style="width:100%; box-sizing:border-box; padding:6px; background:#1e1e1e; border:1px solid #444; color:#fff; border-radius:3px; font-size:12px;">
                    </div>
                </div>

                <div style="display:flex; gap: 15px; align-items:flex-end;">
                    <div style="flex:1;">
                        <label style="font-size:10px; color:#aaa; display:block; margin-bottom:4px;">Sync Mode</label>
                        <select id="sync-mode" style="width:100%; padding:6px; background:#252526; color:#fff; border:1px solid #333; border-radius:3px; font-size:12px;">
                            <option value="mirror">➡ Mirror (Push Local to Remote)</option>
                            <option value="bidirectional">⇆ Bidirectional (Merge Newer)</option>
                        </select>
                    </div>
                    <div style="flex:1;">
                        <label style="font-size:10px; color:#aaa; display:block; margin-bottom:4px;">Excludes</label>
                        <input type="text" id="sync-excludes" value="node_modules, .git, .DS_Store" style="width:100%; box-sizing:border-box; padding:6px; background:#252526; border:1px solid #333; color:#ccc; border-radius:3px; font-family:'Consolas'; font-size:12px;">
                    </div>
                    <button id="sync-btn-analyze" style="padding: 7px 15px; background-color: #007acc; color:white; font-weight:600; border-radius:3px; border:none; cursor:pointer; font-size:12px;">
                        🔍 Analyze
                    </button>
                </div>
            </div>

            <div id="sync-results-container" style="flex-grow:1; display:none; flex-direction:column; border-top: 1px solid #333; background-color: #161616; min-height: 150px;">
                <div style="padding: 6px 15px; background: #202020; border-bottom: 1px solid #333; display:flex; justify-content:space-between; align-items:center; flex-shrink:0;">
                    <span id="sync-summary-text" style="font-size:11px; font-weight:bold; color:#ccc;">Pending Actions</span>
                    <span id="sync-total-size" style="font-size:10px; font-family:'Consolas'; color:#888;"></span>
                </div>
                <div id="sync-list" style="flex-grow:1; overflow-y:auto; padding:0;"></div>
            </div>
        
        </div> 

        <div class="modal-buttons" style="background:#252526; border-top:1px solid #333; padding:10px 20px; display:flex; justify-content:flex-end; gap:10px; flex-shrink:0;">
            <div style="flex-grow:1; display:flex; align-items:center;">
                <span id="sync-status-msg" style="font-size:11px; color:#888;"></span>
            </div>
            <button id="sync-btn-execute" style="background-color: #28a745; display:none; font-weight:bold; padding: 6px 15px; border-radius:3px; border:none; color:white; cursor:pointer; font-size:12px;">🚀 Execute</button>
            <button id="sync-btn-cancel" style="background-color: #3e3e42; padding: 6px 15px; border-radius:3px; border:none; color:#ccc; cursor:pointer; font-size:12px;">Close</button>
        </div>
    </div>
`;