// FILE: ui/js/templates/modals_core.js
// ------------------------------------
// BATCH 31 FIX: Added ID 'btn-about-close' for reliable binding

window.Templates = window.Templates || {};
window.Templates.Modals = window.Templates.Modals || {};

window.Templates.Modals.genericModal = `
    <div class="modal-box">
        <div id="modal-title" class="modal-title">Confirm</div>
        <div id="modal-body" class="modal-body">Message...</div>
        <div class="modal-buttons">
            <button id="modal-btn-cancel" style="background-color: #3e3e42;">Cancel</button>
            <button id="modal-btn-ok">OK</button>
        </div>
    </div>
`;

window.Templates.Modals.progressModal = `
    <div id="progress-title" class="progress-title">Uploading...</div>
    <div class="progress-bar-bg"><div id="progress-bar-fill" class="progress-bar-fill"></div></div>
    <div style="display:flex; justify-content:space-between; align-items:center;">
        <div id="progress-detail" class="progress-detail">Starting...</div>
        <button id="progress-cancel-btn" style="background:none; border:none; color:#ff5555; font-size:11px; cursor:pointer; text-decoration:underline; display:none;">Cancel</button>
    </div>
`;

window.Templates.Modals.aboutModal = `
    <div class="modal-box" style="width:800px; height: 600px; max-height: 90vh;">
        <div class="modal-title">About OmniTerminal</div>
        <div class="modal-body" style="text-align:center; display:flex; flex-direction:column; height:100%;">
            <div style="display:flex; justify-content:space-between; align-items:flex-end; flex-shrink:0;">
                <h2 style="margin:0; color:white;">OmniTerminal v0.1.0</h2>
                <span style="font-size:11px; color:#666;">GPLv3 License &bull; Created by ArchivalCopy.com</span>
            </div>
            <div style="display:flex; gap:20px; margin-top:20px; flex-grow:1; overflow:hidden;">
                <div style="flex:3; display:flex; flex-direction:column;">
                    <div id="kb-tooltip" class="kb-desc-box" style="color:#aaa; font-weight:normal;">
                        Interactive Map<br>Hover over highlighted keys to see available shortcuts.
                    </div>
                    <div id="kb-svg-container" class="kb-container" style="zoom: 0.85;"></div>
                </div>
                <div style="flex:1; border-left:1px solid #333; padding-left:15px; text-align:left; display:flex; flex-direction:column; gap:15px;">
                    <div style="background:#222; padding:10px; border-radius:4px; border:1px solid #444;">
                        <strong style="color:#50fa7b; font-size:12px; display:block; margin-bottom:10px; border-bottom:1px solid #444; padding-bottom:5px;">
                            🔒 SECURITY SETTINGS
                        </strong>
                        <div id="sec-status" style="font-size:11px; margin-bottom:10px; color:#ccc;">
                            Status: <span id="sec-status-text">Checking...</span>
                        </div>
                        <div id="sec-actions">
                            <button id="btn-sec-change" style="width:100%; margin-bottom:5px;">Set Master Password</button>
                            <div id="sec-form" style="display:none; flex-direction:column; gap:5px; margin-top:10px;">
                                <input type="password" id="sec-new-pass" placeholder="New Password" style="width:100%; box-sizing:border-box;">
                                <input type="password" id="sec-confirm-pass" placeholder="Confirm Password" style="width:100%; box-sizing:border-box;">
                                <div style="display:flex; gap:5px; margin-top:5px;">
                                    <button id="btn-sec-save" style="flex:1; background:#28a745;">Save</button>
                                    <button id="btn-sec-cancel" style="flex:1; background:#444;">Cancel</button>
                                </div>
                                <button id="btn-sec-remove" style="width:100%; background:#d9534f; margin-top:5px; display:none;">Remove Password</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-buttons">
            <button id="btn-about-close">Close</button>
        </div>
    </div>
`;