// FILE: ui/js/templates/modals_tools.js
// -------------------------------------
// Checkpoint Wizard & Future Tools

window.Templates = window.Templates || {};
window.Templates.Modals = window.Templates.Modals || {};

window.Templates.Modals.checkpointWizard = `
    <div class="modal-box" style="width: 500px; background-color: #1e1e1e; border: 1px solid #3e3e42; box-shadow: 0 0 30px rgba(0,0,0,0.6); display:flex; flex-direction:column;">
        
        <div class="modal-title" style="padding: 15px 20px; background-color: #252526; border-bottom: 1px solid #333; display:flex; justify-content:space-between; align-items:center;">
            <div style="font-size:15px; font-weight:600; color:#fff;">🛡️ Auto-Checkpoint</div>
            <div style="font-size:18px; cursor:pointer; color:#888;" onclick="document.getElementById('cp-btn-cancel').click()">×</div>
        </div>

        <div class="modal-body" style="padding: 20px; display:flex; flex-direction:column; gap:15px;">
            
            <div style="background:#2d2d30; padding:10px; border-radius:4px; border:1px solid #3e3e42;">
                <div style="color:#50fa7b; font-size:11px; font-weight:bold; margin-bottom:5px; text-transform:uppercase;">Target Folder</div>
                <div style="display:flex; gap:10px;">
                    <input type="text" id="cp-path" placeholder="Select a local folder..." style="flex-grow:1; background:#1e1e1e; border:1px solid #444; color:#fff; padding:6px; font-size:12px; border-radius:3px;">
                    <button id="cp-browse-btn" style="background:#444; color:#fff; border:1px solid #555; padding:4px 10px; border-radius:3px; cursor:pointer;">📂</button>
                </div>
            </div>

            <div style="display:flex; gap:15px;">
                <div style="flex:1;">
                    <label style="font-size:11px; color:#aaa; display:block; margin-bottom:5px;">Interval (Minutes)</label>
                    <input type="number" id="cp-interval" value="60" min="5" style="width:100%; box-sizing:border-box; background:#252526; border:1px solid #333; color:#fff; padding:8px; border-radius:3px;">
                </div>
                <div style="flex:1;">
                    <label style="font-size:11px; color:#aaa; display:block; margin-bottom:5px;">Retention (Count)</label>
                    <input type="number" id="cp-retention" value="10" min="1" style="width:100%; box-sizing:border-box; background:#252526; border:1px solid #333; color:#fff; padding:8px; border-radius:3px;">
                </div>
            </div>

            <div>
                <label style="font-size:11px; color:#aaa; display:block; margin-bottom:5px;">Excludes (Comma separated)</label>
                <textarea id="cp-excludes" style="width:100%; height:60px; box-sizing:border-box; background:#252526; border:1px solid #333; color:#ccc; padding:8px; border-radius:3px; resize:none; font-family:'Consolas'; font-size:11px;">node_modules, target, .git, .vscode, dist, build, .Checkpoints</textarea>
                <div style="font-size:10px; color:#666; margin-top:4px;">Backups are saved to <code>.Checkpoints/YYYY-MM-DD_HH-MM-SS</code></div>
            </div>

        </div>

        <div class="modal-buttons" style="background:#252526; border-top:1px solid #333; padding:15px 20px; display:flex; justify-content:flex-end; gap:10px;">
            <button id="cp-btn-stop" style="background-color: #d9534f; display:none; padding: 8px 15px; border-radius:3px; border:none; color:white; cursor:pointer;">Stop Watcher</button>
            <div style="flex-grow:1"></div>
            <button id="cp-btn-start" style="background-color: #007acc; font-weight:bold; padding: 8px 20px; border-radius:3px; border:none; color:white; cursor:pointer;">Start Watcher</button>
            <button id="cp-btn-cancel" style="background-color: #3e3e42; padding: 8px 15px; border-radius:3px; border:none; color:#ccc; cursor:pointer;">Cancel</button>
        </div>
    </div>
`;