// FILE: ui/js/tools/checkpoint.js
// ------------------------------
// NEW: Logic for Checkpoint Wizard

const CheckpointWizard = {
    activeWatchers: new Set(),

    init: () => {
        // Events are bound when modal opens to ensure elements exist
    },

    open: () => {
        // Ensure template is injected
        if (!document.getElementById('cp-btn-start')) {
            if (window.Templates && window.Templates.Modals && window.Templates.Modals.checkpointWizard) {
                window.Templates.injectModal('checkpoint-wizard-modal', window.Templates.Modals.checkpointWizard);
            }
        }

        const modal = document.getElementById('checkpoint-wizard-modal');
        if (!modal) return;

        // Bind Events
        document.getElementById('cp-btn-cancel').onclick = CheckpointWizard.hide;
        document.getElementById('cp-browse-btn').onclick = CheckpointWizard.browse;
        document.getElementById('cp-btn-start').onclick = CheckpointWizard.start;
        document.getElementById('cp-btn-stop').onclick = CheckpointWizard.stop;

        // Reset UI
        const pathInput = document.getElementById('cp-path');
        const startBtn = document.getElementById('cp-btn-start');
        const stopBtn = document.getElementById('cp-btn-stop');
        
        // Basic check if a path was previously active (simple UI persistence)
        if (pathInput.value && CheckpointWizard.activeWatchers.has(pathInput.value)) {
            startBtn.style.display = 'none';
            stopBtn.style.display = 'inline-block';
            pathInput.disabled = true;
        } else {
            startBtn.style.display = 'inline-block';
            stopBtn.style.display = 'none';
            pathInput.disabled = false;
        }

        modal.style.display = 'flex';
    },

    hide: () => {
        const modal = document.getElementById('checkpoint-wizard-modal');
        if (modal) modal.style.display = 'none';
    },

    browse: async () => {
        try {
            // Using Tauri's dialog plugin via invoke or direct API
            // For now, we simulate or assume the user pastes path, 
            // real folder picker needs `tauri-plugin-dialog` API access in frontend
            // which requires imports. We'll use a prompt fallback for now.
            const path = prompt("Enter absolute path to folder:");
            if (path) {
                document.getElementById('cp-path').value = path.replace(/\\/g, '/');
                CheckpointWizard.checkStatus(path);
            }
        } catch (e) { console.error(e); }
    },

    checkStatus: (path) => {
        const startBtn = document.getElementById('cp-btn-start');
        const stopBtn = document.getElementById('cp-btn-stop');
        const input = document.getElementById('cp-path');

        if (CheckpointWizard.activeWatchers.has(path)) {
            startBtn.style.display = 'none';
            stopBtn.style.display = 'inline-block';
            input.disabled = true;
        } else {
            startBtn.style.display = 'inline-block';
            stopBtn.style.display = 'none';
            input.disabled = false;
        }
    },

    start: async () => {
        const path = document.getElementById('cp-path').value.trim();
        const interval = parseInt(document.getElementById('cp-interval').value);
        const retention = parseInt(document.getElementById('cp-retention').value);
        const excludes = document.getElementById('cp-excludes').value;

        if (!path) return alert("Path is required.");

        try {
            // Call Backend (To be implemented in Batch 15)
            // await invoke('start_checkpoint_watcher', { path, interval, retention, excludes });
            
            // For now, mock success
            console.log(`[Checkpoint] Started watcher for ${path} (${interval}m)`);
            CheckpointWizard.activeWatchers.add(path);
            CheckpointWizard.hide();
            
            // Visual feedback
            alert(`Checkpoint Watcher Started.\n\nTarget: ${path}\nInterval: ${interval} min`);

        } catch (e) {
            alert("Failed to start watcher: " + e);
        }
    },

    stop: async () => {
        const path = document.getElementById('cp-path').value.trim();
        if (!path) return;

        try {
            // await invoke('stop_checkpoint_watcher', { path });
            CheckpointWizard.activeWatchers.delete(path);
            CheckpointWizard.checkStatus(path);
        } catch(e) {
            alert("Error stopping watcher: " + e);
        }
    }
};