// ui/js/utils.js

const Utils = {
    bindEnterKey: (elementId, callback) => {
        const el = document.getElementById(elementId);
        if (el) {
            el.addEventListener('keydown', (e) => {
                if (e.key === 'Enter') {
                    e.preventDefault();
                    callback();
                }
            });
        }
    },

    toggle: (elementId) => {
        const el = document.getElementById(elementId);
        if (el) {
            if (el.style.display === 'none' || el.classList.contains('hidden')) {
                el.style.display = 'block';
                el.classList.remove('hidden');
            } else {
                el.style.display = 'none';
                el.classList.add('hidden');
            }
        }
    },

    base64ToUint8Array: (base64) => {
        const binaryString = atob(base64);
        const len = binaryString.length;
        const bytes = new Uint8Array(len);
        for (let i = 0; i < len; i++) {
            bytes[i] = binaryString.charCodeAt(i);
        }
        return bytes;
    },

    decodeB64: (b64) => {
        try {
            return new TextDecoder().decode(Utils.base64ToUint8Array(b64));
        } catch (e) { return ""; }
    },

    enableMobaStyleControls: (term) => {
        // Auto-Copy
        term.onSelectionChange(() => {
            if (term.hasSelection()) {
                const text = term.getSelection();
                navigator.clipboard.writeText(text).catch(() => {});
            }
        });

        // Right-Click Paste
        const container = term.element;
        if(container) {
            container.addEventListener('contextmenu', async (e) => {
                e.preventDefault();
                try {
                    const text = await navigator.clipboard.readText();
                    if(text) term.paste(text); // Feeds into term.onData
                } catch(err) {}
            });
        }
    }
};